<?php
include('db.php'); // Include database connection

// Get JSON data
$data = json_decode(file_get_contents('php://input'), true);

// Validate input data
if (empty($data['Products']) || !isset($data['Shipping'], $data['Roundoff'], $data['Discount_percentage'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid input data.'
    ]);
    exit;
}

// Assign input data to variables
$order_id = $data['order_id'];
$invoice_id = $data['invoice_id'];
$customerid = $data['customerid'];
$shipping = (float)$data['Shipping'];
$roundoff = (float)$data['Roundoff'];
$discount_percentage = (float)$data['Discount_percentage'];
$balance = (float)$data['Balance'];
$paymentid = $data['paymentid'];
$products = $data['Products'];

$grand_total = 0;
$tax_total = 0;
$discount_total = 0;
$product_total = 0;
$total_savings = 0;
$total_discount = 0;

// Fetch customer details
$user_query = "SELECT displayname FROM customer WHERE id = '$customerid' AND delete_status = 0";
$user_result = mysqli_query($conn, $user_query);

if (mysqli_num_rows($user_result) > 0) {
    $user_data = mysqli_fetch_assoc($user_result);
    $displayname = $user_data['displayname'];
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer not found or inactive.'
    ]);
    exit;
}

// Process each product
foreach ($products as $product) {
    if (!isset($product['Product_id'], $product['Selling_price'], $product['Tax_percentage'], $product['Qty'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid product data.'
        ]);
        exit;
    }

    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];

    // Fetch product details
    $product_query = "SELECT Product_name, MRP, qty, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result = mysqli_query($conn, $product_query);

    if (mysqli_num_rows($product_result) == 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "Product ID $product_id not found or inactive."
        ]);
        exit;
    }

    $product_data = mysqli_fetch_assoc($product_result);
    if ($product_data['qty'] < $qty) {
        echo json_encode([
            'status' => 'error',
            'message' => "Insufficient stock for Product ID $product_id."
        ]);
        exit;
    }

    $mrp = (float)$product_data['MRP'];
    $sale_price_tax = (int)$product_data['sale_price_tax'];

    // Calculate values
    $discount = ($selling_price * $discount_percentage) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = 0;

    if ($sale_price_tax == 2) {
        // Only calculate tax if sale_price_tax is 2
        $tax = ($product_subtotal * $tax_percentage) / 100;
    }

    $product_total += $product_subtotal;
    $tax_total += $tax;
    $discount_total += $discount * $qty;
    $total_savings += ($mrp - $selling_price) * $qty;
}

$grand_total = $product_total + $tax_total + $shipping - $roundoff;
$grand_total1 = number_format((float)$grand_total, 2, '.', '');

// Update `orders`
$created_date = date('Y-m-d H:i:s');
$due_date = date('Y-m-d', strtotime('+7 days'));

$order_query = "
    UPDATE orders
    SET
        user_id = '$customerid',
        displayname = '$displayname',
        Created_date = '$created_date',
        Due_date = '$due_date',
        Balance = '$balance',
        Tax = '$tax_total',
        Discount = '$discount_total',
        Discount_percentage = '$discount_percentage',
        Shipping = '$shipping',
        Roundoff = '$roundoff',
        Total_price = '$product_total',
        Grand_total = '$grand_total1',
        No_of_items = '" . count($products) . "',
        Created_id = '$user_id',
        Editor_id = '$user_id',
        Delete_status = 0,
        Total_saving = '$total_savings',
        Total_discount = '$discount_total',
        Payment_status = " . ($balance == 0 ? 1 : ($balance < $grand_total ? 2 : 0)) . ",
        Payment_id = CONCAT(COALESCE(Payment_id, ''), IF(Payment_id IS NULL OR Payment_id = '', '', ','), '$paymentid')
    WHERE Order_id = '$order_id';";

if (!mysqli_query($conn, $order_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update order.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}

// Update `invoice`
$invoice_query = "
    UPDATE invoice
    SET
        user_id = '$customerid',
        displayname = '$displayname',
        Created_date = '$created_date',
        Due_date = '$due_date',
        Balance = '$balance',
        Tax = '$tax_total',
        Discount = '$discount_total',
        Discount_percentage = '$discount_percentage',
        Shipping = '$shipping',
        Roundoff = '$roundoff',
        Total_price = '$product_total',
        Grand_total = '$grand_total1',
        No_of_items = '" . count($products) . "',
        Created_id = '$user_id',
        Editor_id = '$user_id',
        Delete_status = 0,
        Total_saving = '$total_savings',
        Total_discount = '$discount_total',
        Payment_status = " . ($balance == 0 ? 1 : ($balance < $grand_total ? 2 : 0)) . "
    WHERE order_id = '$order_id';";

if (!mysqli_query($conn, $invoice_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update invoice.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}

// Mark existing order_data and invoice_data records for deletion
$order_data_update_query = "
    UPDATE order_data 
    SET Delete_status = 1
    WHERE Order_id = '$order_id'";
mysqli_query($conn, $order_data_update_query);

$invoice_data_update_query = "
    UPDATE invoice_data 
    SET Delete_status = 1
    WHERE Invoice_id = '$invoice_id'";
mysqli_query($conn, $invoice_data_update_query);

// Insert updated product data into `order_data` and `invoice_data`
foreach ($products as $product) {
    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $product_query2 = "SELECT MRP, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result2 = mysqli_query($conn, $product_query2);

    $product_data2 = mysqli_fetch_assoc($product_result2);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];
    $MRP = (float)$product_data2['MRP'];
    $discount_percentage1 = (float)$product['discount_Percentage'];
    $discount = ($selling_price * $discount_percentage1) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($product_subtotal * $tax_percentage) / 100;
    $Sale_Price_Tax = $product_data2['sale_price_tax'];

    // Insert into `order_data`
    $order_data_insert_query = "
        INSERT INTO order_data (
            Order_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
            Tax_percentage, Tax, salepricetax, Product_total, Delete_status
        ) VALUES (
            '$order_id', '$product_id', '$qty', '$selling_price', '$MRP', '$discount', 
            '$discount_percentage1', '$tax_percentage', '$tax', '$Sale_Price_Tax', '$product_subtotal', 0
        )";
    mysqli_query($conn, $order_data_insert_query);

    // Insert into `invoice_data`
    $invoice_data_insert_query = "
        INSERT INTO invoice_data (
            Invoice_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
            Tax_percentage, Tax, salepricetax, Product_total, Delete_status
        ) VALUES (
            '$invoice_id', '$product_id', '$qty', '$selling_price', '$MRP', '$discount', 
            '$discount_percentage1', '$tax_percentage', '$tax', '$Sale_Price_Tax', '$product_subtotal', 0
        )";
    mysqli_query($conn, $invoice_data_insert_query);

    // Update product stock
    $update_product_query = "
        UPDATE product 
        SET qty = qty - '$qty' 
        WHERE Product_id = '$product_id'";
    mysqli_query($conn, $update_product_query);
    
    $update_inventory_query = "UPDATE inventory  
    SET Qty = Qty - '$qty',
    date_modified = NOW()
    WHERE Product_id = '$product_id'";

mysqli_query($conn, $update_inventory_query);
}

// Update invoice PDF details
if ($invoice_id) {
    // Fetch profile information
    $querys = mysqli_query($conn, "SELECT * FROM user_profile WHERE User_id = 4");

    if (!$querys) {
        die('Error fetching profile data: ' . mysqli_error($conn));
    }

    $profileselect = mysqli_fetch_array($querys);

    // Assign profile data to variables with default values
    $storename = $profileselect['store_name'] ?? 'Default Store Name';
    $email = $profileselect['Email'] ?? 'no-reply@example.com';
    $street1 = $profileselect['Address'] ?? '';
    $street2 = $profileselect['street2'] ?? '';
    $city = $profileselect['City'] ?? '';
    $state = $profileselect['State'] ?? '';
    $pincode = $profileselect['Pincode'] ?? '';
    $phonenumber = $profileselect['Phone'] ?? '';
    $gstno = $profileselect['gstin'] ?? '';
    $logopath = $profileselect['store_image'] ?? '';
    $accountno = $profileselect['acount_no'] ?? '';
    $ifsc = $profileselect['ifsc'] ?? '';
    $bank = $profileselect['bank_name'] ?? '';
    $upiid = $profileselect['upiid'] ?? '';

    // Fetch invoice information
    $query = mysqli_query($conn, "SELECT i.invoice_id, i.invoice_no, i.Created_date, i.Grand_total, c.displayname, c.phoneno, c.address, c.city, c.pincode, c.gstno, c.email, i.order_id, i.user_id
                                  FROM invoice i 
                                  INNER JOIN customer c ON c.id = i.user_id 
                                  WHERE i.invoice_id = '$invoice_id'");

    if (!$query) {
        die('Error fetching invoice data: ' . mysqli_error($conn));
    }

    $invoice = mysqli_fetch_array($query);
    $grandtotal11 = $invoice['Grand_total'];
    $invoice_data = $invoice['Create_date'];

    // Fetch invoice settings
    $query1 = mysqli_query($conn, "SELECT * FROM invoicesetting WHERE 1");

    if (!$query1) {
        die('Error fetching invoice settings: ' . mysqli_error($conn));
    }

    $terms = mysqli_fetch_array($query1);

    // Update invoice PDF details
    $sqlUpdate = "UPDATE invoicepdfdetails SET 
        totalsavings = '$total_savings',
        grandtotal = '$grandtotal11',
        storename = '$storename',
        email = '$email',
        street1 = '$street1',
        street2 = '$street2',
        city = '$city',
        state = '$state',
        pincode = '$pincode',
        phonenumber = '$phonenumber',
        gstnumber = '$gstno',
        logopath = '$logopath',
        notes = '" . $terms['note'] . "',
        account = '$accountno',
        ifsc = '$ifsc',
        bankname = '$bank',
        displayname = '" . $invoice['displayname'] . "',
        phoneno = '" . $invoice['phoneno'] . "',
        address = '" . $invoice['address'] . "',
        customer_city = '" . $invoice['city'] . "',
        customer_pincode = '" . $invoice['pincode'] . "',
        customer_gstno = '" . $invoice['gstno'] . "',
        customer_email = '" . $invoice['email'] . "',
        upiid = '$upiid',
        terms = '" . $terms['terms'] . "',
        qrcode = '" . $terms['qrcode'] . "'
    WHERE invoiceid = '$invoice_id'";

    if (!mysqli_query($conn, $sqlUpdate)) {
        die('Error updating invoice PDF details: ' . mysqli_error($conn));
    } else {
       // echo "Data updated successfully!";
    }
}

// Return success message
echo json_encode([
    'status' => 'success',
    'message' => 'Order updated successfully.'
]);
?>